/**
 * @team: FsFlex Team
 * @since: 1.0.0
 * @author: KP
 */
(function ($) {
    function download(filename, text) {
        var element = document.createElement('a');
        element.setAttribute('href', text);
        element.setAttribute('download', filename);
        element.style.display = 'none';
        document.body.appendChild(element);
        element.click();
        document.body.removeChild(element);
    }
    $(document).on('click', '.button-primary.create-demo', function (e) {
        e.preventDefault();
        if ($('#lqd-ie-id').val() === '') {
            $('#lqd-ie-id').focus();
        } else {
            $('.lqd-export-contents').submit();
        }
    });
    $(document).on('click', '.lqd-import-btn.lqd-import-submit', function (e) {
        e.preventDefault();
        var _form = $(this).parents('form.lqd-ie-demo-item');
        if (confirm('Are you sure you want to install this demo data?')) {
            _form.find(".lqd-loading").css('display', 'block');
            _form.submit();
        } else {
            return;
        }
    });
    $(document).on('click', '.lqd-delete-demo', function (e) {
        e.preventDefault();
        var _this = $(this);
        var _validate = prompt("Type \"reset\" in the confirmation field to confirm the reset and then click the OK button");
        if (_validate === "reset") {
            if (confirm('Are you sure you want to reset site?')) {
                _this.parents('form.lqd-ie-demo-item').find('input[name="action"]').val('lqd-reset');
                _this.parents('form.lqd-ie-demo-item').submit();
            } else {
                return;
            }
        } else {
            if (_validate !== null) {
                alert('Invalid confirmation. Please type \'reset\' in the confirmation field.');
            } else {
                return;
            }
        }
    });
    $(document).on('click', 'li.lqd-advance-reset', function (e) {
        e.preventDefault();
        var _form = $(document).find('form.lqd-reset-form-advance');
        var _validate = prompt("Type \"reset\" in the confirmation field to confirm the reset and then click the OK button");
        if (_validate === "reset") {
            if (confirm('Are you sure you want to reset site?')) {
                _form.submit();
            } else {
                return false;
            }
        } else {
            if (_validate !== null) {
                alert('Invalid confirmation. Please type \'reset\' in the confirmation field.');
            } else {
                return false;
            }
        }
    });
    $(document).on('click', 'li.lqd-show-regenerate-thumbnail', function (e) {
        e.preventDefault();
        var _form = $(document).find('form.lqd-regenerate-thumbnail-sm');
        if (confirm('Are you sure you want to Regenerate Thumbnail?')) {
            _form.submit();
        } else {
            return false;
        }
    });
    $(document).on('click', '.lqd-show-manual-import', function (e) {
        e.preventDefault();
        $(document).find(".lqd-manual-import-layout").css('display','block');
        setTimeout(function () {
            $(document).find(".tabs-contents.lqd-mi-demo-list").addClass("active");
            $(document).find(".lqd-manual-import-layout").removeClass("lqd-m-hidden");
        },10);
    });
    $(document).on('click', '.lqd-contain .dashicons.dashicons-dismiss', function (e) {
        e.preventDefault();
        $(document).find(".lqd-manual-import-layout").addClass("lqd-m-hidden");
        setTimeout(function () {
            $(document).find(".lqd-manual-import-layout").css('display','none');
        },600);
    });

    $(document).on('click', '.lqd-mi-select', function (e) {
        e.preventDefault();
        $(document).find(".lqd-mi-image.lqd-selected").removeClass("lqd-selected");
        $(document).find(".tabs-contents.active").removeClass("active");
        $(document).find("#attachments").addClass("active");
        $(document).find(".tabs-demos[data-id=select-demo]").addClass("lqd-mi-done");
        $(document).find(".tabs-demos[data-id=select-demo]").removeClass("lqd-mi-active");
        $(document).find(".tabs-demos[data-id=attachments]").addClass("lqd-mi-active");
        var _this = $(this),
            _img = _this.parents(".lqd-mi-image");
        _img.addClass("lqd-selected");
        $(".lqd-mi-image-selected img").attr("src",_img.find("img").attr("src"));
        $("#lqd-download-attachment-btn").attr("data-attachment",_this.attr("data-attachment"));
        $(".lqd-mi-demo-title-selected").html(_img.find(".lqd-mi-demo-title").html());
        $("input[name=lqd-ie-id]").val(_this.attr("data-demo"));
        setTimeout(function () {
            $(document).find("#select-demo").css('display','none');
        },300);
    });
    $(document).on('click', '.tabs-demos.lqd-mi-done', function (e) {
        e.preventDefault();
        var _this = $(this);
        $(document).find(".tabs-demos").removeClass("lqd-mi-done");
        $(document).find(".tabs-demos").removeClass("lqd-mi-active");
        var _data_id = _this.attr("data-id");
        switch (_data_id) {
            case "attachments":
                $(document).find(".tabs-demos").removeClass("lqd-mi-done");
                $(document).find(".tabs-demos").removeClass("lqd-mi-active");
                $(document).find(".tabs-contents.active").removeClass("active");
                $(document).find("#attachments").addClass("active");
                $(document).find(".tabs-demos[data-id=select-demo]").addClass("lqd-mi-done");
                $(document).find(".tabs-demos[data-id=select-demo]").removeClass("lqd-mi-active");
                $(document).find(".tabs-demos[data-id=attachments]").addClass("lqd-mi-active");
                break;
            case "select-demo":
                $(document).find("#select-demo").css('display','block');
                $(document).find(".tabs-demos").removeClass("lqd-mi-done");
                $(document).find(".tabs-demos").removeClass("lqd-mi-active");
                setTimeout(function () {
                    $(document).find(".tabs-contents.active").removeClass("active");
                    $(document).find("#select-demo").addClass("active");
                    $(document).find(".tabs-demos[data-id=attachments]").removeClass("lqd-mi-active");
                    $(document).find(".tabs-demos[data-id=select-demo]").addClass("lqd-mi-active");
                },10);
                break;
            default:
                break;
        }
    });
    $(document).on('click','#lqd-download-attachment-btn',function (e) {
        e.preventDefault();
        var _this = $(this);
        download("lqd-attachments.zip",_this.attr("data-attachment"));
    });
    $(document).on('change','#lqd-accept-unzip-done',function (e) {
        e.preventDefault();
        var _checked = $("input#lqd-accept-unzip-done:checked").length;
        if(_checked === 1){
            $(document).find(".lqd-mi-dl-step.step-4 button").addClass("active");
        }else{
            $(document).find(".lqd-mi-dl-step.step-4 button").removeClass("active");
        }
    });
    $(document).on('click','.lqd-mi-dl-step.step-4 button.active',function (e) {
        e.preventDefault();
        var _this = $(this);
        var _checked = $("input#lqd-accept-unzip-done:checked").length;
        if(_checked === 1){
            if (confirm('Are you sure you want to install this demo data?')) {
                _this.next().submit();
            } else {
                return false;
            }
        }else{
            alert("Please accept \"I uploaded and unzipped file\"");
        }
    });
})(jQuery);
